/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.model.output;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import java.util.Objects;
import java.util.Random;
import technology.rocketjump.undermount.mapgen.model.FloorType;
import technology.rocketjump.undermount.mapgen.model.RockGroup;
import technology.rocketjump.undermount.mapgen.model.RoofType;
import technology.rocketjump.undermount.mapgen.model.TileType;
import technology.rocketjump.undermount.mapgen.model.input.GemType;
import technology.rocketjump.undermount.mapgen.model.input.OreType;
import technology.rocketjump.undermount.mapgen.model.input.RockType;
import technology.rocketjump.undermount.mapgen.model.input.ShrubType;
import technology.rocketjump.undermount.mapgen.model.input.TreeType;
import technology.rocketjump.undermount.mapgen.model.output.MapRegion;
import technology.rocketjump.undermount.mapgen.model.output.MapSubRegion;
import technology.rocketjump.undermount.mapgen.model.output.TileSubType;

public class GameMapTile {
    private final boolean isBorderTile;
    private float heightMapValue;
    private float noisyHeightValue;
    private final GridPoint2 position;
    private TileType tileType;
    private TileSubType tileSubType;
    private RoofType roofType = RoofType.Underground;
    private FloorType floorType = FloorType.Outdoor;
    private RockGroup rockGroup = RockGroup.None;
    private RockType rockType = null;
    private OreType ore;
    private GemType gem;
    private MapRegion region;
    private MapSubRegion subRegion;
    private TreeType treeType;
    private ShrubType shrubType;
    private boolean hasRiver;
    private float debugValue;

    public GameMapTile(GridPoint2 position, boolean isBorderTile) {
        this.position = position;
        this.isBorderTile = isBorderTile;
    }

    public GameMapTile(GameMapTile other) {
        this.position = other.position.cpy();
        this.isBorderTile = other.isBorderTile;
        this.floorType = other.floorType;
        this.roofType = other.roofType;
        this.tileType = other.tileType;
        this.tileSubType = other.tileSubType;
        this.heightMapValue = other.heightMapValue;
        this.noisyHeightValue = other.noisyHeightValue;
        this.debugValue = other.debugValue;
        this.rockGroup = other.rockGroup;
        this.rockType = other.rockType;
        this.hasRiver = other.hasRiver;
        this.treeType = other.treeType;
        if (other.region != null) {
            this.region = other.region;
            other.region.remove(other);
            this.region.add(this, null);
            if (other.subRegion != null) {
                this.subRegion = other.subRegion;
                other.subRegion.remove(other);
                this.subRegion.add(this);
            }
        }
    }

    public float getHeightMapValue() {
        return this.heightMapValue;
    }

    public void setHeightMapValue(float height) {
        this.heightMapValue = height;
    }

    public RoofType getRoofType() {
        return this.roofType;
    }

    public void setRoofType(RoofType roofType) {
        this.roofType = roofType;
    }

    public FloorType getFloorType() {
        return this.floorType;
    }

    public void setFloorType(FloorType floorType) {
        this.floorType = floorType;
    }

    public void setAsCave() {
        this.tileType = TileType.MOUNTAIN;
        this.roofType = RoofType.Underground;
        this.floorType = FloorType.Rock;
    }

    public void setAsMountain() {
        this.tileType = TileType.MOUNTAIN;
        this.roofType = RoofType.Underground;
        this.floorType = FloorType.None;
    }

    public void setAsOutside() {
        this.tileType = TileType.OUTSIDE;
        this.roofType = RoofType.Outside;
        this.floorType = FloorType.Outdoor;
    }

    public TileType getTileType() {
        return this.tileType;
    }

    public GridPoint2 getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GameMapTile that = (GameMapTile)o;
        return Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(this.position);
    }

    public boolean isBorderTile() {
        return this.isBorderTile;
    }

    public MapRegion getRegion() {
        return this.region;
    }

    public void setRegion(MapRegion region) {
        this.region = region;
    }

    public boolean hasOre() {
        return this.ore != null;
    }

    public void setOre(OreType ore, Random random) {
        if (this.ore == null) {
            this.ore = ore;
        } else if (random.nextBoolean()) {
            this.ore = ore;
        }
    }

    public OreType getOre() {
        return this.ore;
    }

    public void setGem(GemType gem, Random random) {
        if (this.gem == null) {
            this.gem = gem;
        } else if (random.nextBoolean()) {
            this.gem = gem;
        }
    }

    public GemType getGem() {
        return this.gem;
    }

    public float getNoisyHeightValue() {
        return this.noisyHeightValue;
    }

    public void setNoisyHeightValue(float noisyHeightValue) {
        this.noisyHeightValue = noisyHeightValue;
        this.tileSubType = this.pickTileSubType();
    }

    public MapSubRegion getSubRegion() {
        return this.subRegion;
    }

    public void setSubRegion(MapSubRegion subRegion) {
        this.subRegion = subRegion;
    }

    public TileSubType getTileSubType() {
        return this.tileSubType;
    }

    public void setTileSubType(TileSubType tileSubType) {
        this.tileSubType = tileSubType;
    }

    private TileSubType pickTileSubType() {
        TileSubType subRegionType = this.getTileType().equals((Object)TileType.MOUNTAIN) ? (this.getFloorType().equals((Object)FloorType.None) ? TileSubType.MOUNTAIN_ROCK : TileSubType.CAVE) : this.decideOnOutdoorBiome();
        return subRegionType;
    }

    private TileSubType decideOnOutdoorBiome() {
        if (this.noisyHeightValue < 0.25f) {
            return TileSubType.FOREST;
        }
        if (this.noisyHeightValue < 0.45f) {
            return TileSubType.GRASSLAND;
        }
        if (this.noisyHeightValue < 0.65f) {
            return TileSubType.PLAINS;
        }
        return TileSubType.TUNDRA;
    }

    public boolean hasTree() {
        return this.treeType != null;
    }

    public TreeType getTree() {
        return this.treeType;
    }

    public void setTree(TreeType treeType) {
        this.treeType = treeType;
    }

    public boolean hasRiver() {
        return this.hasRiver;
    }

    public void setRiver(boolean river) {
        this.hasRiver = river;
    }

    public boolean isNavigableByRiver() {
        return this.tileType.equals((Object)TileType.OUTSIDE);
    }

    public Vector2 getWorldPositionOfCenter() {
        return new Vector2((float)this.position.x + 0.5f, (float)this.position.y + 0.5f);
    }

    public RockGroup getRockGroup() {
        return this.rockGroup;
    }

    public void setRockGroup(RockGroup rockGroup) {
        this.rockGroup = rockGroup;
    }

    public RockType getRockType() {
        return this.rockType;
    }

    public void setRockType(RockType rockType) {
        this.rockType = rockType;
    }

    public void setDebugValue(float debugValue) {
        this.debugValue = debugValue;
    }

    public float getDebugValue() {
        return this.debugValue;
    }

    public ShrubType getShrubType() {
        return this.shrubType;
    }

    public void setShrubType(ShrubType shrubType) {
        this.shrubType = shrubType;
    }

    public boolean hasShrub() {
        return this.shrubType != null;
    }
}

